#include <ST7735.h>
#include <SPI.h>

// You can also just connect the reset pin to +5V (we do a software reset)
#define LCD_RESET 8

// These pins are required
#define LCD_CS 10
#define LCD_RS 9

// Color definitions
#define	BLACK           0x0000
#define	BLUE            0x001F
#define	RED             0xF800
#define	GREEN           0x07E0
#define CYAN            0x07FF
#define MAGENTA         0xF81F
#define YELLOW          0xFFE0  
#define WHITE           0xFFFF

ST7735 tft = ST7735(LCD_CS, LCD_RS, LCD_RESET);

void setup(void)
{
	Serial.begin(115200);

	pinMode(LCD_CS, OUTPUT);
	digitalWrite(LCD_CS, HIGH);

	// Fastest SPI clock
	SPI.setClockDivider(SPI_CLOCK_DIV2);

	// Initialize a ST7735R TFT
	tft.initR(); // change this to initB() for ST7735B TFT's

	tft.setRotation(0b00001000);
	tft.fillScreen(BLACK);
}

void loop()
{
	static unsigned long lastData = 0;
	byte data;

	while(Serial.available())
	{
		data = Serial.read();

		// If last byte was more than 50ms ago reset image download state
		if(millis() - lastData > 50)
			tft.setAddrWindow(0, 0, 127, 159); 
		lastData = millis();

		tft.writedata(data);
	}
}
