/*
 * Project: LCD Image Viewer
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#include "config.h"
#include "util.h"
#include "typedefs.h"
#include "LCDImageViewer.h"
#include "lcd.h"
#include "uart.h"
#include "spi.h"
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/power.h>
#include <avr/sleep.h>

volatile ulong milliseconds	= 0;

int main(void)
{
	// Initialize
	init();
	uart_init();
	spi_init();
	lcd_init();

	sei();

	ulong lastData	= 0;
	byte data		= 0;
	ulong ms		= 0;
	
	lcd_setRotation(0b00001000);
	lcd_setAddrWindow(0, 0, 127, 159);
	lcd_blank();
	
    while(1)
    {
		while(uart_get_nb(&data))
		{
			// If last byte was more than 50ms ago reset image download state
			ms = millis();
			if(ms - lastData > 50)
				lcd_setAddrWindow(0, 0, 127, 159);
			lastData = ms;
			
			lcd_writedata(data);
		}
		sleep_mode();
    }
}

static void init()
{
	clock_prescale_set(CPU_DIV);
	ACSR = (1<<ACD);
	power_twi_disable();
	power_adc_disable();
	power_timer0_disable();
	power_timer1_disable();
	set_sleep_mode(SLEEP_MODE_IDLE);

	// Timer 2 settings for approx. millisecond tracking
	TCCR2A = (1<<WGM21);
	TCCR2B = (1<<CS22);
	TIMSK2 = (1<<OCIE2A);
	OCR2A = 250;

	// Set pins as inputs with pull-up, saves a few mA
	DDRB = 0x00;
	DDRC = 0x00;
	DDRD = 0x00;
	PORTB = 0xFF;
	PORTC = 0xFF;
	PORTD = 0xFF;
}

ISR(TIMER2_COMPA_vect)
{
	++milliseconds;
}
