/*
 * Project: LCD Image Viewer
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#ifndef CONFIG_H_
#define CONFIG_H_

#define F_CPU			16000000
#define CPU_DIV			clock_div_1

// Serial baud rate
#define CFG_BAUD		115200

// Use hardware SPI?
#define CFG_SPI_HARDWARE	1

// Software SPI settings
#define CFG_SPI_MOSI_PORT	B
#define CFG_SPI_MOSI_PIN	3
#define CFG_SPI_MISO_PORT	B
#define CFG_SPI_MISO_PIN	4
#define CFG_SPI_SCK_PORT	B
#define CFG_SPI_SCK_PIN		5

// LCD settings
#define CFG_LCD_CS_PORT	B
#define CFG_LCD_CS_PIN	2
#define CFG_LCD_RS_PORT	B
#define CFG_LCD_RS_PIN	1

// 1 = 12bit
// 2 = 16bit
// 3 = 18bit
#define CFG_LCD_COLOUR_MODE 2

#endif /* CONFIG_H_ */