/*
 * Project: LCD Image Viewer
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#include "config.h"

#include "typedefs.h"
#include "uart.h"
#include <avr/io.h>
#include <avr/interrupt.h>

volatile static byte rxBuffer[UART_RXBUFFSIZE];
volatile static byte *volatile rxHead;
volatile static byte *volatile rxTail;

void uart_init()
{
	PORTD |= (1<<PORTD0);
	
	UBRR0 = MYUBRR;
	UCSR0A = (1<<U2X0);
	UCSR0B = (1<<RXEN0)|(1<<RXCIE0);
	UCSR0C = (1<<UCSZ00)|(1<<UCSZ01);
	
	rxHead = rxTail = rxBuffer;
}

bool uart_get_nb(byte* b)
{
	if(rxHead == rxTail)
		return false;

	*b = *rxTail;
	if (++rxTail == (rxBuffer + UART_RXBUFFSIZE))
		rxTail = rxBuffer;

	return true;
}

ISR(USART_RX_vect)
{
	int diff;

	/* buffer full? */
	diff = rxHead - rxTail;
	if(diff < 0)
		diff += UART_RXBUFFSIZE;
	if (diff < UART_RXBUFFSIZE -1)
	{
		// buffer NOT full
		*rxHead = UDR0;
		if (++rxHead == (rxBuffer + UART_RXBUFFSIZE))
			rxHead = rxBuffer;
	}
	else
		UDR0; //reads the buffer to clear the interrupt condition
}