/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#ifndef USB_H_
#define USB_H_

#include "util.h"
#include "config.h"
#include "cpuUsageLed_iface.h"
#include "usb_iface.h"
#include "usbdrv/usbdrv.h"
#include <avr/eeprom.h>
#include <avr/interrupt.h>

#define USB_REQ_DEVSTATE 1
#define USB_REQ_CPUUSAGE 2
#define USB_REQ_SETTING 3
#define SET_MODE_CPUUSAGE 1
#define SET_MODE_SINGLECOL 2
#define SET_TRANSITION_TIME 3

static byte EEMEM eepCalibration = 0xFF;

extern rgbVal currentColour;
extern cpuUsageStatus cpuUsage;
extern settingsS settings;
extern timer idle;
extern timer eepSave;

static void getDeviceState();
static void setCPUUsage(byte usage);
static void setSetting(byte wValue[], byte wIndex[]);
static void calibrateOscillator();
void usbEventResetReady();

#endif /* USB_H_ */