/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#pragma once

#include <comdef.h>
#include <Wbemidl.h>
#include <iostream>

using namespace std;

class cpu
{
private:
	ULONG *ulinitVal;
	ULONG *ulVal;
	IWbemLocator *pLoc;
	IWbemServices *pSvc;

public:
	cpu();
	~cpu();
	bool cpuInit();
	bool GetValues(bool setInitVals);
	double calcUsage(int core);

	int cpuCount;
};