/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#pragma once

#include "stdafx.h"
#include "resource.h"
#include "cpu.h"
#include "usb.h"
#include <iostream>
#include <windows.h>
#include <stdlib.h>
#include <commctrl.h>
#include <usb.h>
//#include <math.h>

#pragma comment(lib, "wbemuuid.lib")
#pragma comment(lib, "libusb.lib")

#define VEN_ID		0x16C0
#define DEV_ID		0x05DC
#define VEN_NAME	"zakkemble.co.uk"
#define DEV_NAME	"CPUUsageLEDs"

// These must match the settings in the uC firmware
#define SET_MODE_CPUUSAGE	1
#define SET_MODE_SINGLECOL	2
#define SET_TRANSITION_TIME	3

using namespace std;
typedef unsigned char byte;

void backend(HWND*, HWND*);
void setDefaults();
void setSingleColour();
void setUsageColour();
void setTransitionTime();
byte map(int, int, int, int, int);
void showCurrentSettings();
void showConnectionStatus();
void setItemText(int, int);
void showCPULoad();
