/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#pragma once

#include <usb.h>
#include <stdio.h>

// These must match the USB request types in the uC firmware
#define USB_REQ_DEVSTATE	1
#define USB_REQ_CPUUSAGE	2
#define USB_REQ_SETTING		3

typedef unsigned char byte;

class usb
{
private:
	int send(byte, int);
	int send(byte, int, int);
	int send(byte, int, int, char*, int);
	void usbOpenDevice();
	int usbGetDescriptorString(usb_dev_handle*, int, int, char*, int);

	int vendor;
	char* vendorName;
	int product;
	char* productName;
	usb_dev_handle* handle;

public:
	usb(int, char*, int, char*);
	~usb();
	bool valid();
	int setCPUUsage(int);
	void getDeviceState();
	void setMode(byte, byte, byte, byte);
	void setSetting(byte, byte);

	byte version[2];

	struct{
		byte maxBrightness;
		byte ledMode;
		byte transitionTime;
	}deviceSettings;

	struct{
		byte red;
		byte green;
		byte blue;
	}deviceRGBVal;
};