/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#ifndef CPUUSAGELED_H_
#define CPUUSAGELED_H_

#include "util.h"
#include "config.h"
#include <avr/pgmspace.h>
#include "sine.h"
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/power.h>
//#include <avr/sleep.h>
#include <avr/wdt.h>
#include <avr/eeprom.h>
#include <util/delay.h>
#include "usbdrv/usbdrv.h"
#include "usbdrv/oddebug.h"
#include "cpuUsageLed_iface.h"
#include "usb_iface.h"

#define RESET_MASK		0b00001000
#define MAX_RGB_LEVEL	255
#define MIN_RGB_LEVEL	0
#define LED_RED_PORT	PORT(CFG_LED_RED_PORT)
#define LED_RED_PIN		PORTBIT(CFG_LED_RED_PORT, CFG_LED_RED_PIN)
#define LED_RED_PWM		CFG_LED_RED_PWM
#define LED_RED_DDR		DDR(CFG_LED_RED_PORT)
#define LED_GREEN_PORT	PORT(CFG_LED_GREEN_PORT)
#define LED_GREEN_PIN	PORTBIT(CFG_LED_GREEN_PORT, CFG_LED_GREEN_PIN)
#define LED_GREEN_PWM	CFG_LED_GREEN_PWM
#define LED_GREEN_DDR	DDR(CFG_LED_GREEN_PORT)
#define LED_BLUE_PORT	PORT(CFG_LED_BLUE_PORT)
#define LED_BLUE_PIN	PORTBIT(CFG_LED_BLUE_PORT, CFG_LED_BLUE_PIN)
#define LED_BLUE_PWM	CFG_LED_BLUE_PWM
#define LED_BLUE_DDR	DDR(CFG_LED_BLUE_PORT)
#define IDLE_TIME		5000
#define SAVE_DELAY_TIME	4000

#define wdt_int_reset()		(WDTCR |= (1<<WDIE)|(1<<WDE))

static volatile bool timerTick;
rgbVal currentColour;
cpuUsageStatus cpuUsage;
settingsS settings;//	= {255,MODE_CPU_USAGE,6};
timer idle				= {false,0};
static timer brightness	= {true,0};
timer eepSave			= {false,0};
#if CFG_WDT_ENABLE
	static volatile bool resetWDT		= false;
#endif
const settingsS eepSettings EEMEM		= {255,MODE_CPU_USAGE,6};
const rgbVal eepRgbVal EEMEM			= {0,0,255};

static void setupHardware();
static void setBrightness(byte level, void (*ledFuncSet)(byte));
static byte getSineVal(byte idx);
static void linearTrans();
static void updateColours();
static byte getColour(byte inMin,byte inMax,byte outMin,byte outMax);
static byte map(byte x, byte in_min, byte in_max, byte out_min, byte out_max);
static byte constrain(byte val, byte min, byte max);
static void flashTest();
static void delay_usbpoll(byte ms);
static void LEDRedSet(byte brightness);
static void LEDGreenSet(byte brightness);
static void LEDBlueSet(byte brightness);
#if CFG_WDT_DEBUG
	static void resetError();
#endif

#endif /* CPUUSAGELED_H_ */