/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#ifndef UTIL_H_
#define UTIL_H_

#define delay(ms) _delay_ms(ms)
#define delay_us(us) _delay_us(us)

#define CONCAT(a, b) a ## b
#define CONCAT2(a, b, c) a ## b ## c
														// Example output
#define PORT(port)			CONCAT(PORT, port)			// PORTB
#define PORTBIT(port, bit)	CONCAT2(PORT, port, bit)	// PORTB2
#define DDR(port)			CONCAT(DDR, port)			// DDRB

#define true				1
#define false				0

typedef unsigned char byte;
typedef unsigned char bool;

typedef struct{
	byte red;
	byte green;
	byte blue;
}rgbVal;

typedef struct{
	byte target;
	byte current;
}cpuUsageStatus;

typedef struct{
	byte maxBrightness;
	byte ledMode;
	byte transitionTime;
}settingsS;

typedef struct{
	bool enabled;
	unsigned int counter;
}timer;

#endif /* UTIL_H_ */