/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

// cpuUsage5.cpp : Defines the entry point for the application.
//

#include "cpuUsage5.h"

// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// the main window class name
//TCHAR szFileName[MAX_PATH];
HWND settingsWnd;
HWND trackbar;
bool settingsDlgOpen;
CLimitSingleInstance g_SingleInstanceObj(TEXT("Global\\{8a198f58-e4b6-4463-a733-2be9f230d8b5}"));

VOID WINAPI TBNotifications( 
    WPARAM wParam,  // wParam of WM_HSCROLL message 
    HWND hwndTrack, // handle of trackbar window 
    UINT iSelMin,   // minimum value of trackbar selection 
    UINT iSelMax);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	// Only run 1 at a time
	if(g_SingleInstanceObj.IsAnotherInstanceRunning())
	{
		MessageBox(NULL, L"Another instance is already running.", L"CPU Usage LEDs", MB_OK | MB_ICONERROR);
		exit(1);
	}

	// Start background stuff
	backend(&settingsWnd, &trackbar, &settingsDlgOpen);

 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_CPUUSAGE5, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_CPUUSAGE5));

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}

//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage are only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_CPUUSAGE5));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_CPUUSAGE5);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW ^ WS_MAXIMIZEBOX ^ WS_THICKFRAME,
      CW_USEDEFAULT, CW_USEDEFAULT, 400, 300, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

//   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message)
	{
	case WM_CREATE:
		{
			NOTIFYICONDATA nid;

			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.hWnd = hWnd;
			nid.uID = 100;
			nid.uVersion = NOTIFYICON_VERSION;
			nid.uCallbackMessage = WM_TRAYMESSAGE;
			nid.hIcon = LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_CPUUSAGE5));
			wcscpy_s(nid.szTip, L"CPU Usage LEDs");
			nid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;

			Shell_NotifyIcon(NIM_ADD, &nid);
			
			//ShowWindow(hWnd,SW_HIDE);
			//HWND button = CreateWindow(L"Button",L"Derp",BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE ,140,70,100,25,hWnd,(HMENU)IDC_MAIN_EDIT,GetModuleHandle(NULL),0);
		}
		break;
	case WM_TRAYMESSAGE:
		switch(lParam)
		{
			case WM_LBUTTONDBLCLK:
				{
					if(!settingsDlgOpen)
						DialogBox(hInst, MAKEINTRESOURCE(IDD_SETTINGSDLG), hWnd, SettingsDlg);
					else
						SetForegroundWindow(settingsWnd);
					/*int msgboxID = MessageBox(hWnd, L"CPU Usage LEDs program.\r\nThis program makes the LEDs change colour according to CPU load.\r\nClose program?", L"CPU Usage LEDs", MB_YESNO | MB_ICONINFORMATION);
					switch (msgboxID)
					{
					case IDYES:
						DestroyWindow(hWnd);
						break;
					case IDNO:
						// TODO: add code
						break;
					}*/
				}
				break;
			default:
				return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Parse the menu selections:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		// TODO: Add any drawing code here...
		EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
		{
			NOTIFYICONDATA nid;
			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.hWnd = hWnd;
			nid.uID = 100;
			Shell_NotifyIcon(NIM_DELETE, &nid);
			PostQuitMessage(0);
		}
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;
	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}

INT_PTR CALLBACK SettingsDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);

	int wmId, wmEvent;

	switch (message)
	{
	case WM_INITDIALOG:
		{
			settingsDlgOpen = true;
			settingsWnd = hDlg;
			SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)LoadIcon(GetModuleHandle(NULL),MAKEINTRESOURCE(IDI_SMALL)));
			SendMessage(hDlg, WM_SETICON, ICON_BIG, (LPARAM)LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_APPLICATION)));
			trackbar = GetDlgItem(hDlg,IDCHC_TRACKBAR);
			SendMessage(trackbar, TBM_SETRANGE, true, MAKELONG(0, 255));
			showCurrentSettings();
			showConnectionStatus();
			SetForegroundWindow(hDlg);
		}
		return (INT_PTR)TRUE;
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		switch(wmId)
		{
		case IDC_BTN_ABOUT:
			MessageBox(hDlg, L"CPU Usage LEDs\r\nVersion 1.1\r\nCopyright (C) Zak Kemble 2012\r\n\r\nzakkemble.co.uk", L"About", MB_OK | MB_ICONINFORMATION);
			return (INT_PTR)TRUE;
		case IDC_BTN_SGL_APPLY:
			setSingleColour();
			return (INT_PTR)TRUE;
		case IDC_BTN_USAGE_APPLY:
			{
				setUsageColour();
				setTransitionTime();
			}
			return (INT_PTR)TRUE;
//		case IDC_BTN_DEFAULTS:
//			setDefaults();
//			return (INT_PTR)TRUE;
		case IDCANCEL:
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		case IDC_BTN_EXIT:
			EndDialog(hDlg, LOWORD(wParam));
			PostQuitMessage(0);
			return (INT_PTR)TRUE;
		}
		break;
	case WM_HSCROLL:
		 {
			LRESULT res = SendMessage(trackbar, TBM_GETPOS, 0, 0);
			setItemText(IDC_EDIT_USAGE_BRT_MAX, res);
			setUsageColour();
			setTransitionTime();
		 }
         break;
	case WM_DESTROY:
		settingsDlgOpen = false;
		break;
	}
	return (INT_PTR)FALSE;
}

