/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

// Fuses for ATtiny45/85
// PLL 16CK/14CK + 64ms startup
// Serial program (SPI) enabled
// Brown-out at 4.3V
// High:		0xDC
// Low:			0xF1
// Extended:	0xFF

#ifndef CONFIG_H_
#define CONFIG_H_

#define F_CPU				16500000 // Don't forget F_CPU in usbdrvasm.S
#define CPU_DIV				clock_div_1

#define CFG_LED_RED_PORT	B
#define CFG_LED_RED_BIT		4
#define CFG_LED_RED_PWM		OCR1B

#define CFG_LED_GREEN_PORT	B
#define CFG_LED_GREEN_BIT	1
#define CFG_LED_GREEN_PWM	OCR0B

#define CFG_LED_BLUE_PORT	B
#define CFG_LED_BLUE_BIT	0
#define CFG_LED_BLUE_PWM	OCR0A

// Watchdog
#define CFG_WDT_ENABLE		1

// Watchdog debug, if the controller was reset by the watchdog then make red LEDs flash
#define CFG_WDT_DEBUG		1

#endif /* CONFIG_H_ */