/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#ifndef CPUUSAGELED_H_
#define CPUUSAGELED_H_

#include "util.h"

#define MAX_RGB_LEVEL	255
#define MIN_RGB_LEVEL	0
#define LED_RED_PORT	PORT(CFG_LED_RED_PORT)
#define LED_RED_BIT		PORTBIT(CFG_LED_RED_PORT, CFG_LED_RED_BIT)
#define LED_RED_PWM		CFG_LED_RED_PWM
#define LED_RED_DDR		DDR(CFG_LED_RED_PORT)
#define LED_GREEN_PORT	PORT(CFG_LED_GREEN_PORT)
#define LED_GREEN_BIT	PORTBIT(CFG_LED_GREEN_PORT, CFG_LED_GREEN_BIT)
#define LED_GREEN_PWM	CFG_LED_GREEN_PWM
#define LED_GREEN_DDR	DDR(CFG_LED_GREEN_PORT)
#define LED_BLUE_PORT	PORT(CFG_LED_BLUE_PORT)
#define LED_BLUE_BIT	PORTBIT(CFG_LED_BLUE_PORT, CFG_LED_BLUE_BIT)
#define LED_BLUE_PWM	CFG_LED_BLUE_PWM
#define LED_BLUE_DDR	DDR(CFG_LED_BLUE_PORT)
#define SAVE_DELAY_TIME	4000

#define MODE_CPU_USAGE	1
#define MODE_SINGLE_COL	2

#define wdt_int_reset()		(WDTCR |= (1<<WDIE)|(1<<WDE))

#endif /* CPUUSAGELED_H_ */