/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#ifndef TYPEDEFS_H_
#define TYPEDEFS_H_

#define true 1
#define false 0

typedef unsigned char byte;
typedef unsigned char bool;
typedef unsigned int uint;

typedef struct{
	byte red;
	byte green;
	byte blue;
}s_rgbVal;

typedef struct{
	byte target;
	byte current;
}s_cpuUsage;

typedef struct{
	byte maxBrightness;
	byte ledMode;
	byte transitionTime;
	byte idleTime;
}s_settings;

typedef struct{
	bool enabled;
	uint counter;
}s_timer;

#endif /* TYPEDEFS_H_ */