/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#include "util.h"
#include "typedefs.h"

// This is the map function from Arduino, modified for byte values instead of long
byte map(byte x, byte in_min, byte in_max, byte out_min, byte out_max)
{
	// At least one of the values must be 32 bit, in this case x is type casted to long since some parts of the calculation can return values down to -65025.
	// Or something like that... without the type cast the return value isn't quite right, map(255,0,255,0,255) would return 254

	return (((long)x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min);
}

// This is the constrain function from Arduino, modified for byte values instead of long
byte constrain(byte val, byte min, byte max)
{
	if(val < min)
		return min;
	else if(val > max)
		return max;
	else
		return val;
}
