/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#ifndef UTIL_H_
#define UTIL_H_

#include "typedefs.h"

#define delay(ms) _delay_ms(ms)
#define delay_us(us) _delay_us(us)

#define CONCAT(a, b) a ## b
#define CONCAT2(a, b, c) a ## b ## c
														// Example output
#define PORT(port)			CONCAT(PORT, port)			// PORTB
#define PORTBIT(port, bit)	CONCAT2(PORT, port, bit)	// PORTB2
#define DDR(port)			CONCAT(DDR, port)			// DDRB

byte map(byte, byte, byte, byte, byte);
byte constrain(byte, byte, byte);

void inline pinWrite(volatile byte* port, byte pin, bool state)
{
	if(state)
		*port |= (1<<pin);
	else
		*port &= ~(1<<pin);
}

#endif /* UTIL_H_ */
