/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#include "typedefs.h"
#include "main.h"
#include "backend.h"
#include <stdio.h>
#include <sys/stat.h>

// http://www-theorie.physik.unizh.ch/~dpotter/howto/daemonize
// Need to improve this, like dont allow multiple daemons
static void daemonize()
{
	pid_t pid;
	pid_t sid;

	/* already a daemon */
	if(getppid() == 1)
		return;

	/* Fork off the parent process */
	pid = fork();
	if (pid < 0)
		exit(EXIT_FAILURE);

	/* If we got a good PID, then we can exit the parent process. */
	if (pid > 0)
		exit(EXIT_SUCCESS);

	/* At this point we are executing as the child process */

	/* Change the file mode mask */
	umask(0);

	/* Create a new SID for the child process */
	sid = setsid();
	if (sid < 0)
		exit(EXIT_FAILURE);

	/* Change the current working directory.  This prevents the current
	directory from being locked; hence not being able to remove it. */
	if((chdir("/")) < 0)
		exit(EXIT_FAILURE);
	
	puts("CPU Usage LEDs started!");

	/* Redirect standard files to /dev/null */
	freopen("/dev/null", "r", stdin);
	freopen("/dev/null", "w", stdout);
	freopen("/dev/null", "w", stderr);
}

int main(int argc, char *argv[])
{
	daemonize();
	backend();
	return EXIT_SUCCESS;
}
