//This code is from Q243953 in case you lose the article and wonder
//where this code came from.
//http://support.microsoft.com/kb/243953

#include "win.h"
#include "typedefs.h"
#include "LimitSingleInstance.h"

#define MUTEXNAME "Global\\{8a198f58-e4b6-4463-a733-2be9f230d8b5}"

static DWORD  m_dwLastError;
static HANDLE m_hMutex;

void LimitSingleInstance()
{
	//Make sure that you use a name that is unique for this application otherwise
	//two apps may think they are the same if they are using same name for
	//3rd parm to CreateMutex
	m_hMutex = CreateMutex(NULL, FALSE, MUTEXNAME); //do early
	m_dwLastError = GetLastError(); //save for use later...
}

void LimitSingleInstance_close()
{
	if (m_hMutex)  //Do not forget to close handles.
	{
		CloseHandle(m_hMutex); //Do as late as possible.
		m_hMutex = NULL; //Good habit to be in.
	}
}

bool IsAnotherInstanceRunning()
{
	return (ERROR_ALREADY_EXISTS == m_dwLastError);
}
