// http://stackoverflow.com/questions/3018313/algorithm-to-convert-rgb-to-hsv-and-hsv-to-rgb

#include "typedefs.h"
#include <math.h>

typedef struct {
    float r;       // percent
    float g;       // percent
    float b;       // percent
} rgb;

typedef struct {
	float h;       // angle in degrees
	float s;       // percent
	float v;       // percent
} hsv;

//static hsv rgb2hsv(rgb in);
static rgb hsv2rgb(hsv in);

void getHue(short position, byte* red, byte* green, byte* blue)
{
	hsv in;
	in.h = position;
	in.s = 1;
	in.v = 1;
	rgb out = hsv2rgb(in);
	*red = out.r * 255;
	*green = out.g * 255;
	*blue = out.b * 255;
}
/*
// This function isn't used
static hsv rgb2hsv(rgb in)
{
    hsv out;
    float min;
    float max;
    float delta;

    min = in.r < in.g ? in.r : in.g;
    min = min  < in.b ? min  : in.b;

    max = in.r > in.g ? in.r : in.g;
    max = max  > in.b ? max  : in.b;

    out.v = max;                                // v
    delta = max - min;
    if( max > 0.0 )
        out.s = (delta / max);                  // s
    else
    {
        // r = g = b = 0                        // s = 0, v is undefined
        out.s = 0.0;
        out.h = NAN;                            // its now undefined
        return out;
    }

    if( in.r >= max )                           // > is bogus, just keeps compilor happy
        out.h = ( in.g - in.b ) / delta;        // between yellow & magenta
    else if( in.g >= max )
        out.h = 2.0 + ( in.b - in.r ) / delta;  // between cyan & yellow
    else
        out.h = 4.0 + ( in.r - in.g ) / delta;  // between magenta & cyan

    out.h *= 60.0;                              // degrees

    if(out.h < 0.0)
        out.h += 360.0;

    return out;
}
*/
static rgb hsv2rgb(hsv in)
{
	float hh;
	float p;
	float q;
    float t;
    float ff;
    long i;
    rgb out;

    if(in.s <= 0.0) // < is bogus, just shuts up warnings
    {
        if(isnan(in.h)) // in.h == NAN
        {
            out.r = in.v;
            out.g = in.v;
            out.b = in.v;
            return out;
        }
        // error - should never happen
        out.r = 0.0;
        out.g = 0.0;
        out.b = 0.0;
        return out;
    }

    hh = in.h;
    if(hh >= 360.0)
    	hh = 0.0;
    hh /= 60.0;
    i = (long)hh;
    ff = hh - i;
    p = in.v * (1.0 - in.s);
    q = in.v * (1.0 - (in.s * ff));
    t = in.v * (1.0 - (in.s * (1.0 - ff)));

    switch(i)
    {
    case 0:
        out.r = in.v;
        out.g = t;
        out.b = p;
        break;
    case 1:
        out.r = q;
        out.g = in.v;
        out.b = p;
        break;
    case 2:
        out.r = p;
        out.g = in.v;
        out.b = t;
        break;

    case 3:
        out.r = p;
        out.g = q;
        out.b = in.v;
        break;
    case 4:
        out.r = t;
        out.g = p;
        out.b = in.v;
        break;
    case 5:
    default:
        out.r = in.v;
        out.g = p;
        out.b = q;
        break;
    }
    return out;
}
