/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#ifndef DEVICE_H_
#define DEVICE_H_

#include "typedefs.h"

void device_open();
void device_close();
bool device_valid();
int device_sendCPU(byte);
void device_setBrightness(byte);
void device_setSingleColour(byte, byte, byte);
void device_setTransitionTime(byte);
void device_setIdleTime(byte);
void device_getState();
s_device* device_get();

#endif /* DEVICE_H_ */
