/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#include "win.h"
#include "typedefs.h"
#include "main.h"
#include "backend.h"
#include "actions.h"
//#include "device.h"
#include "cmdLine.h"
#include "LimitSingleInstance.h"
#include "resource.h"
#include <shellapi.h>
#include <commctrl.h>
#include <stdio.h>

#define MAINCLASSNAME    TEXT("MainWndClass")
#define MAX_LOADSTRING 100

static NOTIFYICONDATA nid;
static TCHAR szTitle[MAX_LOADSTRING];
static HINSTANCE g_hInstance;
static HWND mainWnd;
static HWND settingsWnd;

static BOOL CALLBACK SettingsDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
			{
				settingsWnd = hDlg;
				SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)LoadIcon(g_hInstance, MAKEINTRESOURCE(IDI_SMALL)));
				SendMessage(hDlg, WM_SETICON, ICON_BIG, (LPARAM)LoadIcon(g_hInstance, MAKEINTRESOURCE(IDI_MAIN)));
				SendMessage(GetDlgItem(hDlg, IDCHC_TRACKBAR_BRIGHTNESS), TBM_SETRANGE, TRUE, MAKELONG(0, 255));
				SendMessage(GetDlgItem(hDlg, IDCHC_TRACKBAR_HUE), TBM_SETRANGE, TRUE, MAKELONG(0, 360));
				showCurrentSettings();
				showConnectionStatus();
				SetForegroundWindow(hDlg);
			}
			break;
		case WM_COMMAND:
			{
				int wmId    = LOWORD(wParam);
				//int wmEvent = HIWORD(wParam);
				switch(wmId)
				{
					case IDC_BTN_ABOUT:
						{
							TCHAR aboutStr[MAX_LOADSTRING];
							LoadString(g_hInstance, IDS_ABOUT, aboutStr, MAX_LOADSTRING);
							MessageBox(hDlg, aboutStr, "About", MB_OK | MB_ICONINFORMATION);
						}
						break;
					case IDC_BTN_SGL_APPLY:
						setSingleColour();
						break;
					case IDC_BTN_USAGE_APPLY:
						{
							setUsageBrightness();
							setTransitionTime();
							setIdleTime();
						}
						break;
					case IDCANCEL:
						EndDialog(hDlg, LOWORD(wParam));
						break;
					case IDC_BTN_EXIT:
						EndDialog(hDlg, LOWORD(wParam));
						SendMessage(mainWnd, WM_CLOSE, 0, 0);
						break;
					default:
						return FALSE;
				}
			}
			break;
		case WM_HSCROLL:
			{
				LRESULT position = SendMessage((HWND)lParam, TBM_GETPOS, 0, 0);
				if((HWND)lParam == GetDlgItem(hDlg, IDCHC_TRACKBAR_BRIGHTNESS))
				{
					setItemInt(IDC_EDIT_USAGE_BRT_MAX, position);
					setUsageBrightness();
					setTransitionTime();
					setIdleTime();
				}
				else if((HWND)lParam == GetDlgItem(hDlg, IDCHC_TRACKBAR_HUE))
				{
					getColourHue(position);
					setSingleColour();
				}
				else
					return FALSE;
			}
	        break;
		case WM_UPDATE_TRACKBAR:
			SendMessage(GetDlgItem(hDlg, IDCHC_TRACKBAR_BRIGHTNESS), TBM_SETPOS, TRUE, GetDlgItemInt(hDlg, IDC_EDIT_USAGE_BRT_MAX, NULL, FALSE));
			break;
		case WM_DESTROY:
			settingsWnd = NULL;
			break;
		default:
			return FALSE;
	}
	return TRUE;
}

static LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch (uMsg)
    {
		case WM_CREATE:
			{
				settingsWnd = NULL;
				mainWnd = hWnd;

				nid.cbSize = sizeof(NOTIFYICONDATA);
				nid.hWnd = hWnd;
				nid.uID = 100;
				nid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
				nid.uVersion = NOTIFYICON_VERSION;
				nid.uCallbackMessage = WM_TRAYMESSAGE;
				nid.hIcon = LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_SMALL_OFF));
				wcscpy((WCHAR*)nid.szTip, (WCHAR*)szTitle);

				Shell_NotifyIcon(NIM_ADD, &nid);
			}
			break;
		case WM_TRAYMESSAGE:
			switch(lParam)
			{
				case WM_LBUTTONDBLCLK:
					if(settingsWnd == NULL)
						DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_SETTINGSDLG), hWnd, SettingsDlgProc);
					else
						SetForegroundWindow(settingsWnd);
					break;
				default:
					return DefWindowProc(hWnd, uMsg, wParam, lParam);
			}
			break;
		case WM_CLOSE:
			{
				backend_close();
				Shell_NotifyIcon(NIM_DELETE, &nid);
				DestroyWindow(hWnd);
			}
			break;
		case WM_DESTROY:
			PostQuitMessage(WM_QUIT);
			break;
		default:
			return DefWindowProc(hWnd, uMsg, wParam, lParam);
    }
    return 0;
}

static int begin(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	g_hInstance = hInstance;

	cmdLine_load();
/*
	if(cmdLine_isset("help") || cmdLine_isset("?"))
	{
		MessageBox(NULL, "nogui [brightness [brightness] transition [transition time (ms)] idle [idle timeout (s)]] [colour r [red val] g [green val] b [blue val]]\nExample - set colour to purple: colour r 255 g 0 b 255","Help", MB_ICONINFORMATION | MB_OK);
		return EXIT_SUCCESS;
	}
	else if(cmdLine_isset("nogui"))
	{
		backend();
		Sleep(1000);

		int val;
		char out[100];

		if(cmdLine_getVal("brightness", out))
		{
			val = atoi(out);
			if(val > 255)
				val = 255;
			else if(val < 0)
				val = 0;
			byte brightness = (byte)val;
			device_setBrightness(brightness);
		}

		if(cmdLine_getVal("transition", out))
		{
			val = atoi(out);
			if(val > 65535)
				val = 65535;
			else if(val < 0)
				val = 0;
			uint transitionTime = (uint)val;
			device_setTransitionTime(transitionTime);
		}

		if(cmdLine_getVal("idle", out))
		{
			val = atoi(out);
			if(val > 255)
				val = 255;
			else if(val < 0)
				val = 0;
			byte idleTime = (byte)val;
			device_setIdleTime(idleTime);
		}

		backend_wait();
		return EXIT_SUCCESS;
	}
*/
	if(cmdLine_isset("nogui"))
	{
		backend();
		backend_wait();
		return EXIT_SUCCESS;
	}

	cmdLine_close();

	InitCommonControls();

	LoadString(hInstance, IDS_APPNAME, szTitle, MAX_LOADSTRING);

    WNDCLASSEX wcex = {0};
    wcex.cbSize = sizeof(WNDCLASSEX);
    wcex.lpfnWndProc = WndProc;
    wcex.hInstance = hInstance;
    wcex.lpszClassName = MAINCLASSNAME;
    wcex.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MAIN));
    wcex.hIconSm = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_SMALL));
    wcex.hCursor = LoadCursor(NULL, IDC_ARROW);
    if (!RegisterClassEx(&wcex))
    {
        MessageBox(NULL, "Call to RegisterClassEx failed!", "Error", MB_ICONEXCLAMATION | MB_OK);
        return EXIT_FAILURE;
    }

    // Create your main window.
    HWND hwndMain = CreateWindowEx(0, MAINCLASSNAME, szTitle, WS_OVERLAPPEDWINDOW,
                                   CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, HWND_DESKTOP, NULL,
                                   hInstance, NULL);

	if (!hwndMain)
    {
        MessageBox(NULL, "Call to CreateWindowEx failed!", "Error", MB_ICONEXCLAMATION | MB_OK);
        return EXIT_FAILURE;
    }

    // Show your main window.
//    ShowWindow(hwndMain, nCmdShow);
//    UpdateWindow(hwndMain);

//    ShowWindow( GetConsoleWindow(), SW_SHOW );

    backend();
    actions(&settingsWnd, &nid);

    DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_SETTINGSDLG), hwndMain, SettingsDlgProc);

    // Run the main message loop.
    BOOL bRetVal;
    MSG msg;
    while ((bRetVal = GetMessage(&msg, NULL, 0, 0)))
    {
        if (bRetVal == -1)
        {
            MessageBox(NULL, "Error encountered in message loop!", "Error", MB_ICONEXCLAMATION | MB_OK);
            return EXIT_FAILURE;
        }
        else
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

	return (int)msg.wParam;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	int exitCode;

	// Only run 1 at a time
	LimitSingleInstance();
	if(IsAnotherInstanceRunning())
	{
		MessageBox(NULL, "Another instance is already running.", "CPU Usage LEDs", MB_ICONERROR | MB_OK);
		exitCode = EXIT_FAILURE;
	}
	else
		exitCode = begin(hInstance, hPrevInstance, lpCmdLine, nCmdShow);

	LimitSingleInstance_close();

	return exitCode;
}
