/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#ifndef RESOURCE_H_
#define RESOURCE_H_

#define ID_SET1 (WM_APP + 0)
#define ID_SET2 (WM_APP + 100)
#define ID_SET3 (WM_APP + 200)

// Icons
#define IDI_MAIN						(ID_SET1 + 1)
#define IDI_SMALL						(ID_SET1 + 2)
#define IDI_SMALL_OFF					(ID_SET1 + 3)
#define IDI_SMALL_ON					IDI_SMALL

// Settings dialog
#define IDD_SETTINGSDLG					(ID_SET1 + 4)

// Single colour controls
#define IDC_GRP_SGL                     (ID_SET2 + 1)
#define IDC_STATIC_SGL_RED				(ID_SET2 + 2)
#define IDC_STATIC_SGL_GREEN			(ID_SET2 + 3)
#define IDC_STATIC_SGL_BLUE				(ID_SET2 + 4)
#define IDC_EDIT_SGL_RED				(ID_SET2 + 5)
#define IDC_EDIT_SGL_GREEN				(ID_SET2 + 6)
#define IDC_EDIT_SGL_BLUE				(ID_SET2 + 7)
#define IDC_BTN_SGL_APPLY				(ID_SET2 + 8)

// CPU usage controls
#define IDC_GRP_USAGE                   (ID_SET3 + 1)
//#define IDC_STATIC_USAGE_RED_MIN		(ID_SET3 + 2)
//#define IDC_STATIC_USAGE_RED_MAX		(ID_SET3 + 3)
//#define IDC_STATIC_USAGE_GREEN_MIN		(ID_SET3 + 4)
//#define IDC_STATIC_USAGE_GREEN_MAX		(ID_SET3 + 5)
//#define IDC_STATIC_USAGE_BLUE_MIN		(ID_SET3 + 6)
//#define IDC_STATIC_USAGE_BLUE_MAX		(ID_SET3 + 7)
//#define IDC_EDIT_USAGE_RED_MIN			(ID_SET3 + 8)
//#define IDC_EDIT_USAGE_RED_MAX			(ID_SET3 + 9)
//#define IDC_EDIT_USAGE_GREEN_MIN		(ID_SET3 + 10)
//#define IDC_EDIT_USAGE_GREEN_MAX		(ID_SET3 + 11)
//#define IDC_EDIT_USAGE_BLUE_MIN			(ID_SET3 + 12)
//#define IDC_EDIT_USAGE_BLUE_MAX			(ID_SET3 + 13)
#define IDC_BTN_USAGE_APPLY				(ID_SET3 + 14)
#define IDC_STATIC_USAGE_BRT_MAX		(ID_SET3 + 15)
#define IDC_EDIT_USAGE_BRT_MAX			(ID_SET3 + 16)
#define IDC_EDIT_TRANS_TIME				(ID_SET3 + 17)
#define IDC_STATIC_USAGE_TRANS_TIME		(ID_SET3 + 18)
#define IDC_STATIC_CPU_USAGE			(ID_SET3 + 19)
#define IDC_STATIC_IDLE_TIME			(ID_SET3 + 20)
#define IDC_EDIT_IDLE_TIME				(ID_SET3 + 21)


// General stuff
#define IDC_STATIC_USB_STATUS			(WM_APP + 32)
#define IDC_STATIC_USB_FIRMWARE			(WM_APP + 33)
#define IDC_BTN_ABOUT					(WM_APP + 34)
#define IDC_BTN_EXIT					(WM_APP + 35)
//#define IDC_BTN_DEFAULTS				(WM_APP + 36)
//#define IDC_BTN_DISENABLE				(WM_APP + 37)

#define IDCHC_TRACKBAR_BRIGHTNESS		(WM_APP + 38)
#define IDCHC_TRACKBAR_HUE				(WM_APP + 42)

// Strings
#define IDS_APPNAME						(WM_APP + 39)
#define IDS_ABOUT						(WM_APP + 40)

// Custom messages
#define WM_UPDATE_TRACKBAR				(WM_APP + 41)
#define WM_TRAYMESSAGE					(WM_APP + 42)

#endif /* RESOURCE_H_ */
