/*
 * Project: AVR ATtiny CPU Usage LEDs
 * Author: Zak Kemble, me@zakkemble.co.uk
 * Copyright: (C) 2012 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 */

#ifndef TYPEDEFS_H_
#define TYPEDEFS_H_

#include <usb.h>

#define false 0
#define true 1

typedef unsigned char bool;
typedef unsigned char byte;
typedef unsigned short ushort;
typedef unsigned int uint;

typedef struct{
	byte maxBrightness;
	byte ledMode;
	byte transitionTime;
	byte idleTime;
}s_deviceSettings;

typedef struct{
	byte red;
	byte green;
	byte blue;
}s_rgbVal;

typedef struct{
	usb_dev_handle* handle;
	s_deviceSettings settings;
	s_rgbVal rbg;
	byte version[2];
}s_device;

#endif /* TYPEDEFS_H_ */
