/*
 * Project: AVR ATtiny Fan controller
 * Author: Zak Kemble, contact@zakkemble.co.uk
 * Copyright: (C) 2013 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 * Web: http://blog.zakkemble.co.uk/avr-microcontroller-based-pwm-fan-controllers/
 */

#ifndef FANCONTROLLER_H_
#define FANCONTROLLER_H_

#include "config.h"

#define DELAY_PRESS			CFG_SPEED_DELAY
#define DELAY_SGL_PRESS		CFG_SPEED_DELAY_SGL
#define START_PWR_DELAY		CFG_START_PWR_DELAY
#define START_MAX_DELAY		CFG_START_MAX_DELAY
#define SPEED_STEP			CFG_SPEED_STEP
#define SPEED_MAX			CFG_SPEED_MAX
#define SPEED_MIN			CFG_SPEED_MIN
#define FAN_PORT			PORT(CFG_FAN_PORT)
#define FAN_PIN				PORTBIT(CFG_FAN_PORT, CFG_FAN_PIN)
#define FAN_PWM				CFG_FAN_PWM
#define FAN_DDR				DDR(CFG_FAN_PORT)
#define ANALOGUE_PORT		PORT(CFG_ANALOGUE_PORT)
#define ANALOGUE_PIN		PINBIT(CFG_ANALOGUE_PORT, CFG_ANALOGUE_PIN)
#define SWITCHUP_INT		PCINT(CFG_SWITCHUP_PCINT)
#define SWITCHUP_PPORT		PINPORT(CFG_SWITCHUP_PORT)
#define SWITCHUP_PIN		PINBIT(CFG_SWITCHUP_PORT, CFG_SWITCHUP_PIN)
#define SWITCHUP_PORT		PORT(CFG_SWITCHUP_PORT)
#define SWITCHDOWN_INT		PCINT(CFG_SWITCHDOWN_PCINT)
#define SWITCHDOWN_PPORT	PINPORT(CFG_SWITCHDOWN_PORT)
#define SWITCHDOWN_PIN		PINBIT(CFG_SWITCHDOWN_PORT, CFG_SWITCHDOWN_PIN)
#define SWITCHDOWN_PORT		PORT(CFG_SWITCHDOWN_PORT)
#define INPUT_MODE			CFG_INPUT

#define SWITCHUP_PRESSED()	(bit_is_clear(SWITCHUP_PPORT, SWITCHUP_PIN))
#define SWITCHDOWN_PRESSED()	(bit_is_clear(SWITCHDOWN_PPORT, SWITCHDOWN_PIN))
#define wdt_int_reset()		(WDTCR |= _BV(WDIE)|_BV(WDE))
#if CFG_WDT_ENABLE
	#define delayWDT(ms)		(delayWDT_f(ms))
#else
	#define delayWDT(ms)		(delay(ms))
#endif

#endif /* FANCONTROLLER_H_ */