/*
 * Project: AVR ATtiny Fan controller
 * Author: Zak Kemble, contact@zakkemble.co.uk
 * Copyright: (C) 2013 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 * Web: http://blog.zakkemble.co.uk/avr-microcontroller-based-pwm-fan-controllers/
 */

// Fuses for ATtiny5/10
// BYTE0:		0xFF

#ifndef CONFIG_H_
#define CONFIG_H_

// uC Frequency
#define CPU_DIV					clock_div_256 // 8MHz / 256 = 31.25KHz

// Watchdog
#define CFG_WDT_ENABLE			1 // If the controller crashes for some reason then automatically reset it
#define CFG_WDT_DEBUG			1 // Debug makes the fan turn on and off if the controller was reset by the watchdog

// Fan PWM output
#define CFG_FAN_PORT			B
#define CFG_FAN_PIN				0
#define CFG_FAN_PWM				OCR0A

// If you change the ADC port/pin you'll also need to update ADMUX and DIDRn registers in init()
#define CFG_ANALOGUE_PORT		B
#define CFG_ANALOGUE_PIN		1

// Power on delay
#define CFG_START_PWR_DELAY		200

// Fan start boost time
#define CFG_START_MAX_DELAY		2000

// Depending on how you've wired up the potentiometer, you
// may want to swap which end is max speed and min speed.
#define CFG_SPEED_SWAP			1

#endif /* CONFIG_H_ */