/*
 * Project: AVR ATtiny Fan controller
 * Author: Zak Kemble, contact@zakkemble.co.uk
 * Copyright: (C) 2013 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 * Web: http://blog.zakkemble.co.uk/avr-microcontroller-based-pwm-fan-controllers/
 */

#ifndef FANCONTROLLER_H_
#define FANCONTROLLER_H_

#include "config.h"

#define START_PWR_DELAY		CFG_START_PWR_DELAY
#define START_MAX_DELAY		CFG_START_MAX_DELAY
#define FAN_PORT			PORT(CFG_FAN_PORT)
#define FAN_PIN				PORTBIT(CFG_FAN_PORT, CFG_FAN_PIN)
#define FAN_PWM				CFG_FAN_PWM
#define FAN_DDR				DDR(CFG_FAN_PORT)
#define ANALOGUE_PORT		PORT(CFG_ANALOGUE_PORT)
#define ANALOGUE_PIN		PINBIT(CFG_ANALOGUE_PORT, CFG_ANALOGUE_PIN)

#define wdt_int_reset()		(WDTCSR |= _BV(WDIE)|_BV(WDE))
#if CFG_WDT_ENABLE
	#define delayWDT(ms)		(delayWDT_f(ms))
#else
	#define delayWDT(ms)		(delay(ms))
#endif

#endif /* FANCONTROLLER_H_ */