/*
 * Project: AVR ATtiny Fan controller
 * Author: Zak Kemble, contact@zakkemble.co.uk
 * Copyright: (C) 2013 by Zak Kemble
 * License: GNU GPL v3 (see License.txt)
 * Web: http://blog.zakkemble.co.uk/avr-microcontroller-based-pwm-fan-controllers/
 */

#ifndef UTIL_H_
#define UTIL_H_

#define delay(ms) _delay_ms(ms)

#define CONCAT(a, b) a ## b
#define CONCAT2(a, b, c) a ## b ## c
														// Example output
#define PORT(port)			CONCAT(PORT, port)			// PORTB
#define PORTBIT(port, bit)	CONCAT2(PORT, port, bit)	// PORTB2
#define DDR(port)			CONCAT(DDR, port)			// DDRB
#define PINPORT(port)		CONCAT(PIN, port)			// PINB
#define PINBIT(port, bit)	CONCAT2(PIN, port, bit)		// PINB2
#define PCINT(pcint)		CONCAT(PCINT, pcint)		// PCINT1

#endif /* UTIL_H_ */